from sqlalchemy import Column, Integer, String, DateTime, Text, Float
from sqlalchemy.sql import func
from sqlalchemy.orm import relationship
from app.core.database import Base

class Trip(Base):
    __tablename__ = "trips"

    id = Column(Integer, primary_key=True, index=True)
    name = Column(String(200), nullable=False)
    description = Column(Text, nullable=True)
    creator_name = Column(String(100), nullable=False)
    currency_code = Column(String(3), nullable=False, default="USD")
    share_code = Column(String(10), unique=True, nullable=False, index=True)
    password_hash = Column(String(255), nullable=True)  # Nullable for backward compatibility
    is_active = Column(String(10), default="active")  # active, archived, deleted
    created_at = Column(DateTime(timezone=True), server_default=func.now())
    updated_at = Column(DateTime(timezone=True), onupdate=func.now())

    # Relationships
    participants = relationship("Participant", back_populates="trip")
    expenses = relationship("Expense", back_populates="trip")