from pydantic_settings import BaseSettings
import os

class Settings(BaseSettings):
    # Database
    DATABASE_URL: str = "sqlite:///./juntete.db"

    # Security
    SECRET_KEY: str = "your-secret-key-here-change-in-production"
    ALGORITHM: str = "HS256"
    ACCESS_TOKEN_EXPIRE_MINUTES: int = 30

    # App settings
    APP_NAME: str = "Juntete"
    DEBUG: bool = True

    # CORS
    ALLOWED_ORIGINS: list = ["*"]

    # File upload settings
    UPLOAD_DIR: str = "/app/uploads/receipts"
    MAX_FILE_SIZE: int = 5 * 1024 * 1024  # 5MB
    ALLOWED_EXTENSIONS: set = {"jpg", "jpeg", "png", "webp"}
    MAX_IMAGE_WIDTH: int = 1200
    MAX_IMAGE_HEIGHT: int = 1200
    THUMBNAIL_SIZE: int = 300

    class Config:
        env_file = ".env"

settings = Settings()