/** @type {import('next').NextConfig} */
const nextConfig = {
  // Base path for when app is served under /juntete
  basePath: '/juntete',
  // Asset prefix for static assets
  assetPrefix: '/juntete',

  images: {
    remotePatterns: [
      {
        protocol: 'http',
        hostname: 'localhost',
      },
      {
        protocol: 'https',
        hostname: 'localhost',
      },
    ],
  },
  experimental: {
    optimizePackageImports: ['lucide-react', 'axios', '@tanstack/react-query'],
  },
  compiler: {
    removeConsole: false,
  },
  // Disable aggressive caching in development
  generateBuildId: async () => {
    return 'build-' + Date.now()
  },
  // Enable source maps for debugging
  productionBrowserSourceMaps: true,
  async rewrites() {
    // Get backend URL from environment or use Docker service name
    const backendUrl = process.env.BACKEND_URL || 'http://backend:8000'
    return [
      // Handle /juntete/api routes for production
      {
        source: '/juntete/api/:path*',
        destination: `${backendUrl}/juntete/api/:path*`,
      },
      // Handle /api routes for development and Next.js rewrites
      {
        source: '/api/:path*',
        destination: `${backendUrl}/juntete/api/:path*`,
      },
      {
        source: '/juntete/uploads/:path*',
        destination: `${backendUrl}/juntete/uploads/:path*`,
      },
      {
        source: '/uploads/:path*',
        destination: `${backendUrl}/juntete/uploads/:path*`,
      },
      {
        source: '/juntete/health',
        destination: `${backendUrl}/juntete/health`,
      },
      {
        source: '/health',
        destination: `${backendUrl}/juntete/health`,
      },
    ];
  },
  // Add cache control headers
  async headers() {
    return [
      {
        source: '/_next/static/:path*',
        headers: [
          {
            key: 'Cache-Control',
            value: 'public, max-age=0, must-revalidate',
          },
        ],
      },
      {
        source: '/_next/:path*',
        headers: [
          {
            key: 'Cache-Control',
            value: 'public, max-age=0, must-revalidate',
          },
        ],
      },
    ]
  },
};

module.exports = nextConfig;