'use client'

import { useEffect } from 'react'
import { registerServiceWorker } from '@/lib/service-worker'

export default function ClientLayout({ children }: { children: React.ReactNode }) {
  useEffect(() => {
    // Add manifest link dynamically
    const link = document.createElement('link')
    link.rel = 'manifest'
    link.href = '/manifest.json'
    document.head.appendChild(link)

    // Add theme color meta tag
    const meta = document.createElement('meta')
    meta.name = 'theme-color'
    meta.content = '#3b82f6'
    document.head.appendChild(meta)

    // Register service worker
    registerServiceWorker()

    // Cleanup
    return () => {
      const manifestLink = document.querySelector('link[rel="manifest"]')
      if (manifestLink) {
        document.head.removeChild(manifestLink)
      }
      const themeMeta = document.querySelector('meta[name="theme-color"]')
      if (themeMeta) {
        document.head.removeChild(themeMeta)
      }
    }
  }, [])

  return (
    <div className="min-h-screen bg-gray-50 dark:bg-gray-900">
      <div className="w-full max-w-full overflow-x-hidden">
        {children}
      </div>
    </div>
  )
}

