// Trip types
export interface Trip {
  id: number
  name: string
  description?: string
  creator_name: string
  currency_code: string
  share_code: string
  is_active: string
  created_at: string
  updated_at?: string
  access_token?: string
  requires_auth?: boolean
}

export interface TripCreate {
  name: string
  description?: string
  creator_name: string
  currency_code: string
}

// Participant types
export interface Participant {
  id: number
  trip_id: number
  name: string
  is_creator: boolean
  is_active: boolean
  created_at: string
}

export interface ParticipantCreate {
  name: string
}

// Expense types
export interface Expense {
  id: number
  trip_id: number
  description: string
  amount: number
  currency_code: string
  exchange_rate: number
  amount_in_trip_currency: number
  category?: string
  receipt_url?: string
  paid_by_id: number
  paid_by_name: string
  date_incurred: string
  created_at: string
  splits: ExpenseSplit[]
}

export interface ExpenseCreate {
  description: string
  amount: number
  currency_code: string
  exchange_rate?: number
  category?: string
  receipt_url?: string
  paid_by_id: number
  splits: ExpenseSplitCreate[]
}

export interface ExpenseSplit {
  id: number
  expense_id: number
  participant_id: number
  participant_name: string
  percentage: number
  amount: number
  is_settled: boolean
  created_at: string
}

export interface ExpenseSplitCreate {
  participant_id: number
  percentage: number
}

// User Identity types
export interface UserIdentity {
  id: string
  participantName: string
  tripId: string
  deviceId: string
  createdAt: number
  lastAccessed: number
}

// Currency types
export interface Currency {
  id: number
  code: string
  name: string
  symbol: string
  is_active: boolean
}

// API Response types
export interface TripWithParticipants extends Trip {
  participants: Participant[]
}

export interface JoinTripResponse {
  trip: Trip
  participants: Participant[]
}