'use client'

import { useState } from 'react'

interface TripTabsProps {
  activeTab: 'expenses' | 'analytics'
  onTabChange: (tab: 'expenses' | 'analytics') => void
  tripId: number
  tripCurrency: string
  participants: Array<{ id: number; name: string; is_creator: boolean }>
  refreshTrigger?: number
  onExpenseUpdated?: () => void
}

import ExpenseList from './ExpenseList'
import AnalyticsDashboard from './AnalyticsDashboard'

export default function TripTabs({
  activeTab,
  onTabChange,
  tripId,
  tripCurrency,
  participants,
  refreshTrigger,
  onExpenseUpdated
}: TripTabsProps) {
  return (
    <div className="space-y-4">
      {/* Tab Navigation */}
      <div className="bg-white dark:bg-gray-800 p-1 rounded-lg border dark:border-gray-700">
        <div className="grid grid-cols-2 gap-1">
          <button
            onClick={() => onTabChange('expenses')}
            className={`py-2 px-4 rounded-md font-medium text-sm transition-colors ${
              activeTab === 'expenses'
                ? 'bg-blue-600 dark:bg-blue-700 text-white'
                : 'text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700'
            }`}
          >
            Expenses
          </button>
          <button
            onClick={() => onTabChange('analytics')}
            className={`py-2 px-4 rounded-md font-medium text-sm transition-colors ${
              activeTab === 'analytics'
                ? 'bg-blue-600 dark:bg-blue-700 text-white'
                : 'text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700'
            }`}
          >
            Analytics
          </button>
        </div>
      </div>

      {/* Tab Content */}
      {activeTab === 'expenses' && (
        <ExpenseList
          tripId={tripId}
          refreshTrigger={refreshTrigger}
          participants={participants}
          tripCurrency={tripCurrency}
          onExpenseUpdated={onExpenseUpdated}
        />
      )}

      {activeTab === 'analytics' && (
        <AnalyticsDashboard
          tripId={tripId}
          tripCurrency={tripCurrency}
          participants={participants}
          refreshTrigger={refreshTrigger}
        />
      )}
    </div>
  )
}