from pydantic import BaseModel, Field

class TripAuthRequest(BaseModel):
    trip_id: int
    password: str = Field(..., min_length=1)

class TripAuthResponse(BaseModel):
    access_token: str
    token_type: str = "bearer"
    trip_id: int

