"""
Seed data for the juntete application
"""
from sqlalchemy.orm import Session
from app.core.database import SessionLocal, engine
from app.core.database import Base
from app.models import Currency

def seed_currencies():
    """Seed common currencies"""
    db = SessionLocal()

    # Check if currencies already exist
    if db.query(Currency).count() > 0:
        print("Currencies already exist")
        return

    currencies = [
        {"code": "USD", "name": "US Dollar", "symbol": "$"},
        {"code": "EUR", "name": "Euro", "symbol": "€"},
        {"code": "GBP", "name": "British Pound", "symbol": "£"},
        {"code": "JPY", "name": "Japanese Yen", "symbol": "¥"},
        {"code": "CNY", "name": "Chinese Yuan", "symbol": "¥"},
        {"code": "INR", "name": "Indian Rupee", "symbol": "₹"},
        {"code": "AUD", "name": "Australian Dollar", "symbol": "A$"},
        {"code": "CAD", "name": "Canadian Dollar", "symbol": "C$"},
        {"code": "CHF", "name": "Swiss Franc", "symbol": "Fr"},
        {"code": "AED", "name": "UAE Dirham", "symbol": "د.إ"},
        {"code": "SAR", "name": "Saudi Riyal", "symbol": "﷼"},
        {"code": "QAR", "name": "Qatari Riyal", "symbol": "﷼"},
        {"code": "KWD", "name": "Kuwaiti Dinar", "symbol": "د.ك"},
        {"code": "BHD", "name": "Bahraini Dinar", "symbol": "ب.د"},
        {"code": "OMR", "name": "Omani Rial", "symbol": "ر.ع."}
    ]

    for currency_data in currencies:
        currency = Currency(**currency_data)
        db.add(currency)

    db.commit()
    print(f"Added {len(currencies)} currencies")

if __name__ == "__main__":
    # Create all tables
    Base.metadata.create_all(bind=engine)

    # Seed currencies
    seed_currencies()

    print("Database seeded successfully!")