from pydantic import BaseModel, Field
from datetime import datetime
from typing import List, Optional

class TripCreate(BaseModel):
    name: str = Field(..., min_length=1, max_length=200)
    description: Optional[str] = None
    creator_name: str = Field(..., min_length=1, max_length=100)
    currency_code: str = Field(..., min_length=3, max_length=3)
    password: Optional[str] = Field(None, min_length=0, max_length=100)  # Optional password

class TripResponse(BaseModel):
    id: int
    name: str
    description: Optional[str]
    creator_name: str
    currency_code: str
    share_code: str
    is_active: str
    created_at: datetime
    updated_at: Optional[datetime]

    class Config:
        from_attributes = True

class TripWithParticipants(TripResponse):
    participants: List[dict] = []  # Will be populated with participant data

class ParticipantCreate(BaseModel):
    name: str = Field(..., min_length=1, max_length=100)

class ParticipantResponse(BaseModel):
    id: int
    trip_id: int
    name: str
    is_creator: bool
    is_active: bool
    created_at: datetime

    class Config:
        from_attributes = True