from sqlalchemy import Column, Integer, String, DateTime, Boolean, ForeignKey, Text
from sqlalchemy.sql import func
from sqlalchemy.orm import relationship
from app.core.database import Base

class Participant(Base):
    __tablename__ = "participants"

    id = Column(Integer, primary_key=True, index=True)
    trip_id = Column(Integer, ForeignKey("trips.id"), nullable=False)
    name = Column(String(100), nullable=False)
    email = Column(String(255), nullable=True)  # Optional, for future features
    phone = Column(String(20), nullable=True)   # Optional, for future features
    is_creator = Column(Boolean, default=False)
    is_active = Column(Boolean, default=True)
    device_id = Column(String(100), nullable=True)  # For anonymous user identification
    last_accessed = Column(DateTime(timezone=True), nullable=True)
    created_at = Column(DateTime(timezone=True), server_default=func.now())
    updated_at = Column(DateTime(timezone=True), onupdate=func.now())

    # Relationships
    trip = relationship("Trip", back_populates="participants")
    expenses_paid = relationship("Expense", foreign_keys="Expense.paid_by_id", back_populates="paid_by")
    expense_splits = relationship("ExpenseSplit", back_populates="participant")