from pydantic import BaseModel, Field
from datetime import datetime
from typing import List, Optional

class ExpenseSplitCreate(BaseModel):
    participant_id: int
    percentage: float = Field(..., gt=0, le=100)

class ExpenseSplitResponse(BaseModel):
    id: int
    expense_id: int
    participant_id: int
    participant_name: str  # Joined from participant table
    percentage: float
    amount: float
    is_settled: bool
    created_at: datetime

    class Config:
        from_attributes = True

class ExpenseCreate(BaseModel):
    description: str = Field(..., min_length=1, max_length=255)
    amount: float = Field(..., gt=0)
    currency_code: str = Field(..., min_length=3, max_length=3)
    exchange_rate: float = Field(default=1.0, gt=0)
    category: Optional[str] = None
    receipt_url: Optional[str] = None
    paid_by_id: int
    splits: List[ExpenseSplitCreate]
    date_incurred: Optional[datetime] = None

class ExpenseResponse(BaseModel):
    id: int
    trip_id: int
    description: str
    amount: float
    currency_code: str
    exchange_rate: float
    amount_in_trip_currency: float  # Calculated field
    category: Optional[str]
    receipt_url: Optional[str]
    paid_by_id: int
    paid_by_name: str  # Joined from participant table
    date_incurred: datetime
    created_at: datetime
    splits: List[ExpenseSplitResponse]

    class Config:
        from_attributes = True