from fastapi import FastAPI
from fastapi.middleware.cors import CORSMiddleware
from fastapi.staticfiles import StaticFiles
from app.api import trips, participants, expenses, auth, currency, export, uploads
from app.core.config import settings

app = FastAPI(
    title="Tritri API",
    description="Group expense tracking API",
    version="1.0.0",
    root_path="/juntete"
)

# CORS middleware
app.add_middleware(
    CORSMiddleware,
    allow_origins=["*"],  # In production, set specific origins
    allow_credentials=True,
    allow_methods=["*"],
    allow_headers=["*"],
)

# Include blueprints
app.include_router(auth.router, prefix="/api/auth", tags=["auth"])
app.include_router(trips.router, prefix="/api/trips", tags=["trips"])
app.include_router(participants.router, prefix="/api/participants", tags=["participants"])
app.include_router(expenses.router, prefix="/api/expenses", tags=["expenses"])
app.include_router(currency.router, prefix="/api/currency", tags=["currency"])
app.include_router(export.router, prefix="/api/export", tags=["export"])
app.include_router(uploads.router, prefix="/api/uploads", tags=["uploads"])

# Mount static files for uploaded images
# This serves files from /app/uploads at /uploads URL path
try:
    app.mount("/uploads", StaticFiles(directory=settings.UPLOAD_DIR), name="uploads")
except RuntimeError:
    # Directory doesn't exist yet, will be created when needed
    pass

@app.get("/")
async def root():
    return {"message": "Tritri API - Group Expense Tracking"}

@app.get("/health")
async def health_check():
    return {"status": "healthy"}