from pydantic import BaseModel, Field
from datetime import datetime

class ParticipantCreate(BaseModel):
    name: str = Field(..., min_length=1, max_length=100)

class ParticipantResponse(BaseModel):
    id: int
    trip_id: int
    name: str
    is_creator: bool
    is_active: bool
    created_at: datetime

    class Config:
        from_attributes = True