// Helper functions for caching pages
export async function cacheCurrentPage() {
  if (typeof window === 'undefined' || !('caches' in window)) {
    return
  }

  try {
    const cache = await caches.open('juntete-runtime-v1')
    const currentUrl = window.location.href
    
    // Try to fetch and cache the current page
    const response = await fetch(currentUrl)
    if (response.ok) {
      await cache.put(currentUrl, response.clone())
      console.log('Cached current page:', currentUrl)
    }
  } catch (error) {
    console.log('Failed to cache current page:', error)
  }
}

export async function ensurePageCached(url: string) {
  if (typeof window === 'undefined' || !('caches' in window)) {
    return false
  }

  try {
    const cache = await caches.open('juntete-runtime-v1')
    const cached = await cache.match(url)
    
    if (!cached) {
      // Try to fetch and cache
      const response = await fetch(url)
      if (response.ok) {
        await cache.put(url, response.clone())
        return true
      }
    }
    return !!cached
  } catch (error) {
    console.log('Failed to ensure page cached:', error)
    return false
  }
}

