import { defineConfig, devices } from '@playwright/test';

/**
 * Playwright configuration for production testing
 * Tests against https://geeplo.com/juntete instead of localhost
 */
export default defineConfig({
  testDir: './tests',
  fullyParallel: true,
  forbidOnly: !!process.env.CI,
  retries: process.env.CI ? 2 : 0,
  workers: process.env.CI ? 1 : undefined,
  reporter: 'html',
  use: {
    /* Use production URL for tests */
    baseURL: 'https://geeplo.com/juntete',
    trace: 'on-first-retry',
    /* Ignore HTTPS errors for production testing */
    ignoreHTTPSErrors: true,
  },

  /* Configure projects for major browsers */
  projects: [
    {
      name: 'chromium',
      use: { ...devices['Desktop Chrome'] },
    },
    {
      name: 'Mobile Chrome',
      use: { ...devices['Pixel 5'] },
    },
  ],

  /* No webServer needed for production testing */
  webServer: undefined,
});