'use client'

import { useState } from 'react'

interface CopyLinkProps {
  shareCode: string
}

export default function CopyLink({ shareCode }: CopyLinkProps) {
  const [showCopiedMessage, setShowCopiedMessage] = useState(false)

  const handleCopyLink = async () => {
    const shareUrl = `${window.location.origin}/join?code=${shareCode}`

    try {
      if (typeof navigator !== 'undefined' && navigator.clipboard && navigator.clipboard.writeText) {
        await navigator.clipboard.writeText(shareUrl)
        setShowCopiedMessage(true)
        setTimeout(() => setShowCopiedMessage(false), 2000)
      } else {
        // Fallback for older browsers
        const textArea = document.createElement('textarea')
        textArea.value = shareUrl
        document.body.appendChild(textArea)
        textArea.focus()
        textArea.select()
        document.execCommand('copy')
        document.body.removeChild(textArea)
        setShowCopiedMessage(true)
        setTimeout(() => setShowCopiedMessage(false), 2000)
      }
    } catch (err) {
      console.error('Error copying to clipboard:', err)
    }
  }

  return (
    <div className="relative">
      <button
        onClick={handleCopyLink}
        className="flex items-center space-x-2 bg-blue-600 dark:bg-blue-500 text-white px-4 py-2 rounded-lg hover:bg-blue-700 dark:hover:bg-blue-600 transition-colors"
      >
        <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3" />
        </svg>
        <span>Copy Link</span>
      </button>

      {showCopiedMessage && (
        <div className="absolute top-full left-1/2 transform -translate-x-1/2 mt-2 bg-gray-800 dark:bg-gray-700 text-white text-sm px-3 py-1 rounded-md whitespace-nowrap z-10">
          Link copied to clipboard!
          <div className="absolute -top-1 left-1/2 transform -translate-x-1/2 w-2 h-2 bg-gray-800 dark:bg-gray-700 rotate-45"></div>
        </div>
      )}
    </div>
  )
}