#!/bin/bash

# Auto-fix script for Next.js caching issues
# This script clears all caches and ensures clean startup

echo "🔄 Starting Next.js with cache prevention..."

# Clear all possible caches
rm -rf .next
rm -rf cache
rm -rf node_modules/.cache

# Create .next directory if it doesn't exist
mkdir -p .next

# Set environment variables to prevent caching issues
export NODE_OPTIONS="--max-old-space-size=4096"
export NEXT_TELEMETRY_DISABLED=1
export DISABLE_ESLINT_PLUGIN=true
export NEXT_REACT_ROOT=true
export FORCE_COLOR=1

echo "✅ Caches cleared, starting Next.js..."

# Start Next.js with cache prevention
exec npm run dev