import { test, expect } from '@playwright/test';

test.describe('Trip Sharing Functionality', () => {
  test('should join trip using lowercase share code', async ({ page }) => {
    // Test with lowercase share code
    await page.goto('/join?code=omwwqt');

    // Wait for the page to load and handle the URL parameter
    await page.waitForTimeout(1000); // Allow more time for auto-trigger

    // Check if we successfully found the trip and are showing participant selection
    // Look for the welcome message which includes the trip name "1123"
    await expect(page.locator('text=Welcome to 1123!')).toBeVisible({ timeout: 15000 });

    // Look for the "Who are you?" text that indicates participant selection
    await expect(page.locator('text=Who are you?')).toBeVisible();
  });

  test('should handle manual code entry with mixed case', async ({ page }) => {
    // Go to join page without parameters
    await page.goto('/join');

    // Enter mixed case share code manually
    await page.fill('input[id="share-code"]', 'OmWwQt');

    // Click Find Trip button
    await page.click('button:has-text("Find Trip")');

    // Should successfully find the trip - look for specific elements
    await expect(page.locator('text=Welcome to 1123!')).toBeVisible({ timeout: 10000 });
    await expect(page.locator('text=Who are you?')).toBeVisible();
  });

  test('should handle password-protected trips correctly', async ({ page }) => {
    // Test with password-protected share code
    await page.goto('/join?code=543KB4');

    // Wait for the page to load and handle the URL parameter
    await page.waitForTimeout(1000);

    // Should show password prompt, not validation error
    await expect(page.locator('text=Password Required')).toBeVisible({ timeout: 15000 });
    await expect(page.locator('text=This trip is password protected')).toBeVisible();
  });

  test('should show error for invalid code length', async ({ page }) => {
    // Go to join page
    await page.goto('/join');

    // Enter invalid short code
    await page.fill('input[id="share-code"]', 'ABC12');

    // Click Find Trip button (should be disabled since length is not 6)
    const findButton = page.locator('button:has-text("Find Trip")');
    await expect(findButton).toBeDisabled();
  });
});